/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.jobs.handler;

import jtbcore.jobs.TaskBase;
import jtbcore.jobs.TaskUpdate;
import jtbcore.jobs.interfaces.RunnableException;
import jtbcore.jobs.interfaces.RunnableExceptionHandler;

public class SimpleTask {
    public static Thread run(Runnable run) {
        Thread t = new Thread(run);
        t.start();
        return t;
    }

    public static Thread run(RunnableException run, RunnableExceptionHandler exceptionHandler) {
        Thread t = new Thread(() -> {
            try {
                run.run();
            }
            catch (Exception ex) {
                if (exceptionHandler != null) {
                    exceptionHandler.handleException(ex);
                }
                ex.printStackTrace();
            }
        });
        t.start();
        return t;
    }

    public static Thread runFinish(RunnableException run, RunnableException runFinished, RunnableExceptionHandler exceptionHandler) {
        Thread t = new Thread(() -> {
            try {
                run.run();
                if (runFinished != null) {
                    runFinished.run();
                }
            }
            catch (Exception ex) {
                if (exceptionHandler != null) {
                    exceptionHandler.handleException(ex);
                }
                ex.printStackTrace();
            }
        });
        t.start();
        return t;
    }

    public static void run(TaskBase task) {
        try {
            SimpleTask.run(() -> {
                try {
                    task.update("start", TaskUpdate.MessageType.STARTED, 0, 0.0);
                    task.execute();
                    task.update("finished", TaskUpdate.MessageType.FINISHED, 0, 100.0);
                }
                catch (Exception ex) {
                    if (task.getExceptionHandler() != null) {
                        task.getExceptionHandler().handleException(ex);
                    }
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception ex) {
            task.handleException(ex);
        }
    }
}

